/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;

public class HarvestEquipmentFeature
extends EquipmentFeature {
    private static final Set<Block> SPADE_HARVEST = Sets.newHashSet((Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_150458_ak, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_192444_dS});
    private static final Set<Block> PICKAXE_HARVEST = Sets.newHashSet((Object[])new Block[]{Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150334_T, Blocks.field_150318_D, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150439_ay, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U, Blocks.field_150430_aB, Blocks.field_150456_au});
    private static final Set<Block> AXE_HARVEST = Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_150471_bO, Blocks.field_150452_aw});
    public String harvestType;
    public String harvestShape = "block";
    public float harvestSpeed = 1.0f;
    public int harvestLevel = 3;
    public Vec3i harvestRange = new Vec3i(0, 0, 0);

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        this.harvestType = json.get("harvestType").getAsString();
        if (json.has("harvestType")) {
            this.harvestType = json.get("harvestType").getAsString();
        }
        if (json.has("harvestSpeed")) {
            this.harvestSpeed = json.get("harvestSpeed").getAsFloat();
        }
        if (json.has("harvestLevel")) {
            this.harvestLevel = json.get("harvestLevel").getAsInt();
        }
        if (json.has("harvestShape")) {
            this.harvestShape = json.get("harvestShape").getAsString();
        }
        this.harvestRange = JSONHelper.getVec3i(json, "harvestRange");
    }

    @Override
    public String getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        return LanguageManager.translate("equipment.feature." + this.featureType) + " " + this.getSummary(itemStack, level);
    }

    @Override
    public String getSummary(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        String summary = LanguageManager.translate("equipment.harvest.type." + this.harvestType);
        Vec3i vec3i = new Vec3i(0, 0, 0);
        if (this.harvestRange.func_177951_i(vec3i) > 0.0) {
            summary = summary + " (" + LanguageManager.translate("equipment.harvest.shape." + this.harvestShape);
            summary = summary + " " + this.getHarvestRangeString(level);
            summary = summary + ")";
        }
        return summary;
    }

    public String getHarvestRangeString(int level) {
        String harvestRangeString = "" + (this.harvestRange.func_177958_n() * 2 + 1);
        harvestRangeString = harvestRangeString + "x" + (this.harvestRange.func_177956_o() + 1);
        harvestRangeString = harvestRangeString + "x" + (this.harvestRange.func_177952_p() + 1);
        return harvestRangeString;
    }

    public String getToolType() {
        return this.harvestType;
    }

    public boolean canHarvestBlock(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        Material material = blockState.func_185904_a();
        if (material == Material.field_151573_f || material == Material.field_151574_g || material == Material.field_151576_e || PICKAXE_HARVEST.contains(block)) {
            return this.harvestType.equalsIgnoreCase("pickaxe");
        }
        if (material == Material.field_151575_d || AXE_HARVEST.contains(block)) {
            return this.harvestType.equalsIgnoreCase("axe");
        }
        if (material == Material.field_151585_k || material == Material.field_151582_l) {
            return this.harvestType.equalsIgnoreCase("axe") || this.harvestType.equalsIgnoreCase("sword") || this.harvestType.equalsIgnoreCase("shears");
        }
        if (material == Material.field_151569_G || material == Material.field_151584_j) {
            return this.harvestType.equalsIgnoreCase("sword") || this.harvestType.equalsIgnoreCase("shears");
        }
        if (material == Material.field_151580_n) {
            return this.harvestType.equalsIgnoreCase("shears");
        }
        if (material == Material.field_151578_c || material == Material.field_151595_p || material == Material.field_151577_b || material == Material.field_151597_y || material == Material.field_151596_z || SPADE_HARVEST.contains(block)) {
            return this.harvestType.equalsIgnoreCase("shovel");
        }
        if (material == Material.field_151589_v || material == Material.field_151572_C) {
            return this.harvestType.equalsIgnoreCase("sword");
        }
        if (block == Blocks.field_150473_bD) {
            return this.harvestType.equalsIgnoreCase("shears");
        }
        return false;
    }

    public float getHarvestSpeed(IBlockState blockState) {
        if (!this.canHarvestBlock(blockState)) {
            return 0.0f;
        }
        return this.harvestSpeed * this.getHarvestMultiplier(blockState);
    }

    public float getHarvestMultiplier(IBlockState blockState) {
        Material material = blockState.func_185904_a();
        if (material == Material.field_151569_G) {
            return 10.0f;
        }
        if ((material == Material.field_151584_j || material == Material.field_151582_l) && this.harvestType.equalsIgnoreCase("shears")) {
            return 10.0f;
        }
        return 1.0f;
    }

    public void onBlockDestroyed(World world, IBlockState harvestedBlockState, BlockPos harvestedPos, EntityLivingBase livingEntity) {
        if (livingEntity == null || livingEntity.func_70093_af()) {
            return;
        }
        EnumFacing facingH = livingEntity.func_174811_aO();
        EnumFacing facingLat = facingH.func_176746_e();
        EnumFacing facing = facingH;
        if (livingEntity.field_70125_A > 45.0f) {
            facing = EnumFacing.DOWN;
        } else if (livingEntity.field_70125_A < -45.0f) {
            facing = EnumFacing.UP;
        }
        Vec3i[][] selectionRanges = new Vec3i[3][2];
        int lon = 0;
        int lat = 1;
        int vert = 2;
        int min = 0;
        int max = 1;
        selectionRanges[lon][min] = new Vec3i(Math.min(0, this.harvestRange.func_177952_p() * facing.func_82601_c()), Math.min(0, this.harvestRange.func_177952_p() * facing.func_96559_d()), Math.min(0, this.harvestRange.func_177952_p() * facing.func_82599_e()));
        selectionRanges[lon][max] = new Vec3i(Math.max(0, this.harvestRange.func_177952_p() * facing.func_82601_c()), Math.max(0, this.harvestRange.func_177952_p() * facing.func_96559_d()), Math.max(0, this.harvestRange.func_177952_p() * facing.func_82599_e()));
        selectionRanges[lat][min] = new Vec3i(this.harvestRange.func_177958_n() * -Math.abs(facingLat.func_82601_c()), this.harvestRange.func_177958_n() * -Math.abs(facingLat.func_96559_d()), this.harvestRange.func_177958_n() * -Math.abs(facingLat.func_82599_e()));
        selectionRanges[lat][max] = new Vec3i(this.harvestRange.func_177958_n() * Math.abs(facingLat.func_82601_c()), this.harvestRange.func_177958_n() * Math.abs(facingLat.func_96559_d()), this.harvestRange.func_177958_n() * Math.abs(facingLat.func_82599_e()));
        if (facing != EnumFacing.DOWN && facing != EnumFacing.UP) {
            int vertOffset = this.harvestRange.func_177956_o() != 0 ? -1 : 0;
            selectionRanges[vert][min] = new Vec3i(0, vertOffset, 0);
            selectionRanges[vert][max] = new Vec3i(0, this.harvestRange.func_177956_o() + vertOffset, 0);
        } else {
            selectionRanges[vert][min] = new Vec3i((double)((float)(this.harvestRange.func_177956_o() * -Math.abs(facingH.func_82601_c())) * 0.5f), (double)((float)(this.harvestRange.func_177956_o() * -Math.abs(facingH.func_96559_d())) * 0.5f), (double)((float)(this.harvestRange.func_177956_o() * -Math.abs(facingH.func_82599_e())) * 0.5f));
            selectionRanges[vert][max] = new Vec3i((double)((float)(this.harvestRange.func_177956_o() * Math.abs(facingH.func_82601_c())) * 0.5f), (double)((float)(this.harvestRange.func_177956_o() * Math.abs(facingH.func_96559_d())) * 0.5f), (double)((float)(this.harvestRange.func_177956_o() * Math.abs(facingH.func_82599_e())) * 0.5f));
        }
        if (this.harvestShape.equalsIgnoreCase("block") || this.harvestShape.equalsIgnoreCase("random")) {
            boolean random = this.harvestShape.equalsIgnoreCase("random");
            for (int longX = selectionRanges[lon][min].func_177958_n(); longX <= selectionRanges[lon][max].func_177958_n(); ++longX) {
                for (int longY = selectionRanges[lon][min].func_177956_o(); longY <= selectionRanges[lon][max].func_177956_o(); ++longY) {
                    for (int longZ = selectionRanges[lon][min].func_177952_p(); longZ <= selectionRanges[lon][max].func_177952_p(); ++longZ) {
                        for (int latX = selectionRanges[lat][min].func_177958_n(); latX <= selectionRanges[lat][max].func_177958_n(); ++latX) {
                            for (int latY = selectionRanges[lat][min].func_177956_o(); latY <= selectionRanges[lat][max].func_177956_o(); ++latY) {
                                for (int latZ = selectionRanges[lat][min].func_177952_p(); latZ <= selectionRanges[lat][max].func_177952_p(); ++latZ) {
                                    for (int vertX = selectionRanges[vert][min].func_177958_n(); vertX <= selectionRanges[vert][max].func_177958_n(); ++vertX) {
                                        for (int vertY = selectionRanges[vert][min].func_177956_o(); vertY <= selectionRanges[vert][max].func_177956_o(); ++vertY) {
                                            for (int vertZ = selectionRanges[vert][min].func_177952_p(); vertZ <= selectionRanges[vert][max].func_177952_p(); ++vertZ) {
                                                BlockPos destroyPos = harvestedPos.func_177982_a(longX, longY, longZ).func_177982_a(latX, latY, latZ).func_177982_a(vertX, vertY, vertZ);
                                                if (!this.shouldHarvestBlock(world, harvestedBlockState, harvestedPos, destroyPos) || random && !world.field_73012_v.nextBoolean()) continue;
                                                world.func_175655_b(destroyPos, true);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return;
        }
        if (this.harvestShape.equalsIgnoreCase("cross")) {
            for (int longX = selectionRanges[lon][min].func_177958_n(); longX <= selectionRanges[lon][max].func_177958_n(); ++longX) {
                for (int longY = selectionRanges[lon][min].func_177956_o(); longY <= selectionRanges[lon][max].func_177956_o(); ++longY) {
                    for (int longZ = selectionRanges[lon][min].func_177952_p(); longZ <= selectionRanges[lon][max].func_177952_p(); ++longZ) {
                        BlockPos destroyPos;
                        for (int latX = selectionRanges[lat][min].func_177958_n(); latX <= selectionRanges[lat][max].func_177958_n(); ++latX) {
                            for (int latY = selectionRanges[lat][min].func_177956_o(); latY <= selectionRanges[lat][max].func_177956_o(); ++latY) {
                                for (int latZ = selectionRanges[lat][min].func_177952_p(); latZ <= selectionRanges[lat][max].func_177952_p(); ++latZ) {
                                    destroyPos = harvestedPos.func_177982_a(longX, longY, longZ).func_177982_a(latX, latY, latZ);
                                    if (!this.shouldHarvestBlock(world, harvestedBlockState, harvestedPos, destroyPos)) continue;
                                    world.func_175655_b(destroyPos, true);
                                }
                            }
                        }
                        for (int vertX = selectionRanges[vert][min].func_177958_n(); vertX <= selectionRanges[vert][max].func_177958_n(); ++vertX) {
                            for (int vertY = selectionRanges[vert][min].func_177956_o(); vertY <= selectionRanges[vert][max].func_177956_o(); ++vertY) {
                                for (int vertZ = selectionRanges[vert][min].func_177952_p(); vertZ <= selectionRanges[vert][max].func_177952_p(); ++vertZ) {
                                    destroyPos = harvestedPos.func_177982_a(longX, longY, longZ).func_177982_a(vertX, vertY, vertZ);
                                    if (!this.shouldHarvestBlock(world, harvestedBlockState, harvestedPos, destroyPos)) continue;
                                    world.func_175655_b(destroyPos, true);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean shouldHarvestBlock(World world, IBlockState harvestedBlockState, BlockPos harvestedPos, BlockPos targetPos) {
        if (harvestedPos.equals((Object)targetPos)) {
            return false;
        }
        IBlockState targetBlockState = world.func_180495_p(targetPos);
        if (!(targetBlockState.func_177230_c() != Blocks.field_150450_ax && targetBlockState.func_177230_c() != Blocks.field_150439_ay || harvestedBlockState.func_177230_c() != Blocks.field_150450_ax && harvestedBlockState.func_177230_c() != Blocks.field_150439_ay)) {
            return this.canHarvestBlock(world.func_180495_p(targetPos));
        }
        if (targetBlockState.func_177230_c() != harvestedBlockState.func_177230_c()) {
            return false;
        }
        if (world.func_175625_s(targetPos) != null) {
            return false;
        }
        return this.canHarvestBlock(world.func_180495_p(targetPos));
    }

    public boolean onBlockUsed(World world, EntityPlayer player, BlockPos pos, ItemStack itemStack, EnumFacing facing) {
        if (!"hoe".equals(this.harvestType)) {
            return false;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemStack)) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(pos);
        int hook = ForgeEventFactory.onHoeUse((ItemStack)itemStack, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (hook != 0) {
            return false;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (facing != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                this.hoeBlock(itemStack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                return true;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        this.hoeBlock(itemStack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                        return true;
                    }
                    case COARSE_DIRT: {
                        this.hoeBlock(itemStack, player, world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected void hoeBlock(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state, 11);
        }
    }

    public boolean onEntityInteraction(EntityPlayer player, EntityLivingBase entity, ItemStack itemStack) {
        if (!"shears".equals(this.harvestType) || player.func_130014_f_().field_72995_K) {
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (target.isShearable(itemStack, (IBlockAccess)entity.field_70170_p, pos)) {
                List drops = target.onSheared(itemStack, (IBlockAccess)entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack));
                Random rand = new Random();
                for (ItemStack stack : drops) {
                    EntityItem ent = entity.func_70099_a(stack, 1.0f);
                    ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
            }
            return true;
        }
        return false;
    }
}

